﻿<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Business.Db" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Raport sprzedaży porównawczy wg cech towarów</title>

    <script runat="server"> 

        public enum KategoriaRaportu {
            Sprzedaż,
            Zakup,
            WydanieMagazynowe,
            PrzyjęcieMagazynowe
        }

        public class ParametryContext : ContextBase {
            BusinessModule businessmodule;
            
            public ParametryContext(Context cx)
                : base(cx) {
                businessmodule = BusinessModule.GetInstance(cx.Session);
            }

            private FromTo _okresA = Date.Now.Month - 1 == 0 ? FromTo.Month(Date.Now.Year - 1, 12) : FromTo.Month(Date.Now.Year, Date.Now.Month - 1);

            [Soneta.Tools.Priority(10)]
            [Caption("Okres A")]
            public Soneta.Types.FromTo OkresA {
                get {
                    return this._okresA;
                }
                set {
                    this._okresA = value;
                }
            }

            private FromTo _okresB = FromTo.Month(Date.Now.Year, Date.Now.Month);

            [Soneta.Tools.Priority(20)]
            [Caption("Okres B")]
            public Soneta.Types.FromTo OkresB {
                get {
                    return this._okresB;
                }
                set {
                    this._okresB = value;
                }
            }

            private bool _ignorujZaliczkowe = true;

            [Soneta.Tools.Priority(30)]
            public bool IgnorujZaliczkowe {
                get {
                    return this._ignorujZaliczkowe;
                }
                set {
                    this._ignorujZaliczkowe = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            FeatureDefinition _cechaTowaru;

            [Soneta.Tools.Priority(40)]
            [Caption("Cecha towaru")]
            public FeatureDefinition CechaTowaru {
                get { return this._cechaTowaru; }
                set { this._cechaTowaru = value; OnChanged(EventArgs.Empty); }
            }

            public object GetListCechaTowaru() {
                return businessmodule.FeatureDefs.ByName["Towary"];
            }

            private KategoriaRaportu _kategoriaRaportu = KategoriaRaportu.Sprzedaż;

            [Soneta.Tools.Priority(50)]
            public KategoriaRaportu KategoriaRaportu {
                get {
                    return this._kategoriaRaportu;
                }
                set {
                    this._kategoriaRaportu = value;
                    OnChanged(EventArgs.Empty);
                }
            }

            private bool liczMarze = false;

            [Soneta.Tools.Priority(60)]
            [Caption("Policz marże")]
            public bool LiczMarze {
                get {
                    return liczMarze;
                }
                set {
                    liczMarze = value;
                }
            }
            
        }

        static ParametryContext parametry;

        [Context]
        public static ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }

        public class Total : IComparable {
            readonly string wartośćCechy;
            readonly bool liczMarze = false;
            
            double ilośćA = 0;
            decimal nettoA = 0;
            double ilośćB = 0;
            decimal nettoB = 0;
            double ilośćBmA = 0;
            decimal nettoBmA = 0;
            Percent ilośćBmAwP = Percent.Zero;
            Percent nettoBmAwP = Percent.Zero;

            decimal marzaA = 0;
            decimal marzaB = 0;
            decimal marzaBmA = 0;
            Percent marzaBmAwP = Percent.Zero;

            public Total(string wartośćCechy, bool LiczMarze) {
                this.wartośćCechy = wartośćCechy;
                this.liczMarze = LiczMarze;
            }
            
            public void PrzeliczRoznice() {
                ilośćBmA = ilośćB - ilośćA;
                nettoBmA = nettoB - nettoA;
                ilośćBmAwP = ilośćA != 0d ? new Percent((decimal)(ilośćBmA / ilośćA)) : new Percent(1m);
                nettoBmAwP = nettoA != 0m ? new Percent(nettoBmA / nettoA) : new Percent(1m);
                if (liczMarze)
                {
                    marzaBmA = marzaB - marzaA;
                    marzaBmAwP = marzaA != 0m ? new Percent(marzaBmA / marzaA) : new Percent(1m);
                }
            }
            
            SumaPozycjiWorker spw = new SumaPozycjiWorker();
            ObrotyDokumentuWorker otw = new ObrotyDokumentuWorker();
            List<int> dokumenty = new List<int>();
            
            public void AddA(PozycjaDokHandlowego pozycja, string wartośćCechy) {
                if (this.wartośćCechy != wartośćCechy)
                    return;
                spw.Pozycja = pozycja;
                nettoA += spw.Netto;
                ilośćA += pozycja.ZmianaMagazynu.Ilość.Value;
                if (liczMarze && !dokumenty.Contains(pozycja.Dokument.ID))
                {
                    dokumenty.Add(pozycja.Dokument.ID);
                    otw.Dokument = pozycja.Dokument;
                    marzaA += otw.Marża;
                }
                PrzeliczRoznice();
            }
            public void AddB(PozycjaDokHandlowego pozycja, string wartośćCechy) {
                if (this.wartośćCechy != wartośćCechy)
                    return;
                spw.Pozycja = pozycja;
                nettoB += spw.Netto;
                ilośćB += pozycja.ZmianaMagazynu.Ilość.Value;
                if (liczMarze && !dokumenty.Contains(pozycja.Dokument.ID))
                {
                    dokumenty.Add(pozycja.Dokument.ID);
                    otw.Dokument = pozycja.Dokument;
                    marzaB += otw.Marża;
                }
                PrzeliczRoznice();
            }
            public string WartośćCechy {
                get { return wartośćCechy; }
            }
            public decimal NettoA {
                get { return nettoA; }
            }
            public double IlośćA {
                get { return ilośćA; }
            }
            public decimal NettoB {
                get { return nettoB; }
            }
            public double IlośćB {
                get { return ilośćB; }
            }
            public decimal RóżnicaNetto {
                get { return nettoBmA; }
            }
            public Percent RóżnicaNettoP {
                get { return nettoBmAwP; }
            }
            public double RóżnicaIlości {
                get { return ilośćBmA; }
            }
            public Percent RóżnicaIlościP {
                get { return ilośćBmAwP; }
            }

            public decimal MarzaA {
                get {
                    return marzaA;
                }
            }

            public decimal MarzaB {
                get {
                    return marzaB;
                }
            }

            public decimal RoznicaMarza {
                get {
                    return marzaBmA;
                }
            }

            public Percent RoznicaMarzaP {
                get {
                    return marzaBmAwP;
                }
            }
            
            public int CompareTo(object obj) {
                Total t = (Total)obj;
                return WartośćCechy.CompareTo(t.WartośćCechy);
            }
        }

        public RowCondition KategoriaCondition() {
            switch (Parametry.KategoriaRaportu) {
                case KategoriaRaportu.Sprzedaż:
                    return new FieldCondition.GreaterEqual("Kategoria", KategoriaHandlowa.Sprzedaż)
                            & new FieldCondition.LessEqual("Kategoria", KategoriaHandlowa.KorektaSprzedaży);
                    break;
                case KategoriaRaportu.Zakup:
                    return new FieldCondition.GreaterEqual("Kategoria", KategoriaHandlowa.Zakup)
                            & new FieldCondition.LessEqual("Kategoria", KategoriaHandlowa.KorektaZakupu);
                    break;
                case KategoriaRaportu.WydanieMagazynowe:
                    return new FieldCondition.GreaterEqual("Kategoria", KategoriaHandlowa.WydanieMagazynowe)
                            & new FieldCondition.LessEqual("Kategoria", KategoriaHandlowa.KorektaWydaniaMagazynowego);
                    break;
                case KategoriaRaportu.PrzyjęcieMagazynowe:
                    return new FieldCondition.GreaterEqual("Kategoria", KategoriaHandlowa.PrzyjęcieMagazynowe)
                            & new FieldCondition.LessEqual("Kategoria", KategoriaHandlowa.KorektaPrzyjęciaMagazynowego);
                    break;
                default:
                    return RowCondition.Empty;
                    break;
            }
        }

        Soneta.Business.View PrzygotujView(Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars) {
            HandelModule handel = HandelModule.GetInstance(pars);

            Soneta.Business.View view;

            //////////////////////////////////////////////////////////////////////
            /// Dla podmiotu
            /// 
            if (pars.Kontrahent != null) {
                SubTable st;
                if (pars.Magazyn != null) {
                    st = handel.DokHandlowe.WgKontrahent[pars.Kontrahent, pars.Magazyn];
                    if (pars.JestOkres)
                        st = new SubTable(st, pars.Okres);
                }
                else
                    st = handel.DokHandlowe.WgKontrahent[pars.Kontrahent];
                view = st.CreateView();
                if (pars.JestOkres && pars.Magazyn == null)
                    view.Condition &= new FieldCondition.Contain("Data", pars.Okres);
                if (pars.Definicja != null)
                    view.Condition &= new FieldCondition.Equal("Definicja", pars.Definicja);
            }

            ///////////////////////////////////////////////////////////////////////
            /// Definicja
            /// 
            else if (pars.Definicja != null && pars.Magazyn != null) {
                SubTable st = handel.DokHandlowe.WgDefinicja[pars.Definicja, pars.Magazyn];
                if (pars.JestOkres)
                    st = new SubTable(st, pars.Okres);
                view = st.CreateView();
            }

            //////////////////////////////////////////////////////////////////////
            /// Magazyn
            /// 
            else if (pars.Magazyn != null) {
                SubTable st = handel.DokHandlowe.WgMagazyn[pars.Magazyn];
                if (pars.JestOkres)
                    st = new SubTable(st, pars.Okres);

                view = st.CreateView();
            }

            //////////////////////////////////////////////////////////////////////
            /// Tylko okres
            /// 
            else {
                SubTable st = handel.DokHandlowe.WgDaty;
                if (pars.JestOkres)
                    st = new SubTable(st, pars.Okres);
                view = st.CreateView();
                if (pars.Definicja != null)
                    view.Condition &= new FieldCondition.Equal("Definicja", pars.Definicja);
            }

            view.Condition &= KategoriaCondition();

            if (!string.IsNullOrEmpty(pars.Seria))
                view.Condition &= new FieldCondition.Like("Seria", pars.Seria);

            if (!pars.Duplikaty)
                view.Condition &= new FieldCondition.Equal("Definicja.DuplikatWartosci", false);

            view.Condition &= DokHandlowe.UtwórzCondition("", pars.Stan);

            if (pars.WedługDaty == WedługDatyDokumentu.Terminu || pars.WedługDaty == WedługDatyDokumentu.PoTerminie) {
                if (pars.Okres != FromTo.All)
                    view.Condition &= new FieldCondition.Contain("Dostawa.Termin", pars.Okres.ValidDates);
                if (pars.WedługDaty == WedługDatyDokumentu.PoTerminie)
                    view.Condition &= !new RowCondition.Exists("RelacjaHandlowa", "Nadrzedny",
                        new FieldCondition.Equal("Typ", TypRelacjiHandlowej.Kopiowania) &
                        new FieldCondition.GreaterEqual("Rozliczenie", RozliczenieRelacji.CałośćWCzęściach));
            }

            switch (pars.Pozycje) {
                case FiltrPozycji.TylkoUsługi:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.Equal("Towar.Typ", TypTowaru.Usługa));
                    view.Condition &= new RowCondition.Not(
                        new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                            new FieldCondition.NotEqual("Towar.Typ", TypTowaru.Usługa)));
                    break;

                case FiltrPozycji.TylkoTowary:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.NotEqual("Towar.Typ", TypTowaru.Usługa));
                    view.Condition &= new RowCondition.Not(
                        new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.Equal("Towar.Typ", TypTowaru.Usługa)));
                    break;

                case FiltrPozycji.ZUsługami:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.Equal("Towar.Typ", TypTowaru.Usługa));
                    break;

                case FiltrPozycji.ZTowarami:
                    view.Condition &= new RowCondition.Exists("PozycjaDokHandlowego", "Dokument",
                        new FieldCondition.NotEqual("Towar.Typ", TypTowaru.Usługa));
                    break;
            }

            switch (pars.Potwierdzenie) {
                case FiltrPotwierdzenia.Niepotwierdzone:
                    view.Condition &= new FieldCondition.Equal("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Niepotwierdzony);
                    break;

                case FiltrPotwierdzenia.Potwierdzone:
                    view.Condition &= new FieldCondition.Equal("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Potwierdzony);
                    break;

                case FiltrPotwierdzenia.Zaakceptowane:
                    view.Condition &= new FieldCondition.Equal("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Zaakceptowany);
                    break;

                case FiltrPotwierdzenia.Niezaakceptowane:
                    view.Condition &= new FieldCondition.NotEqual("Potwierdzenie", PotwierdzenieDokumentuHandlowego.Zaakceptowany);
                    break;
            }

            RowCondition rodzajCond = null;
            switch (pars.RodzajVAT) {
                case FiltrRodzajuVAT.Krajowe:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Krajowy);
                    break;

                case FiltrRodzajuVAT.Unijne:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Unijny);
                    break;
                case FiltrRodzajuVAT.UnijneTrójstronne:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.UnijnyTrójstronny);
                    break;
                case FiltrRodzajuVAT.UnijneRazem:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Unijny)
                        | new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.UnijnyTrójstronny);
                    break;

                case FiltrRodzajuVAT.Eksportowe:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Eksportowy);
                    break;
                case FiltrRodzajuVAT.EksportowePodróżne:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.EksportowyPodróżny);
                    break;
                case FiltrRodzajuVAT.EksportoweRazem:
                    rodzajCond = new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.Eksportowy)
                        | new FieldCondition.Equal("RodzajPodmiotu", RodzajPodmiotu.EksportowyPodróżny);
                    break;
            }
            if (rodzajCond != null)
                view.Condition &= new RowCondition.Exists("DaneKontrahenta", "Host", rodzajCond
                    & new FieldCondition.Equal("Typ", DokumentHandlowy.TypDanychKontrahent));

            view.Condition &= pars.FiltrRelacji.Condition;

            view.FilterCondition += new ConditionHandler(view_FilterCondition);

            return view;
        }

        private void view_FilterCondition(object sender, ConditionEventArgs args) {
            DokumentHandlowy dok = (DokumentHandlowy)args.Row;
            if (dok.Definicja.GetObjectRight() == AccessRights.Denied)
                args.Accepted = false;
        }

        void OnContextLoad(Object sender, EventArgs args) {
            if (Parametry.CechaTowaru == null)
                throw new ArgumentException("Nie wybrano cechy!");
            Soneta.Handel.Forms.DokHandloweViewInfo.WParams pars = (Soneta.Handel.Forms.DokHandloweViewInfo.WParams)dc[typeof(Soneta.Handel.Forms.DokHandloweViewInfo.WParams)];
            Date dfrom = Date.Empty;
            Date dto = Date.Empty;
            if (Parametry.OkresA.From <= Parametry.OkresB.From)
                dfrom = Parametry.OkresA.From;
            else
                dfrom = Parametry.OkresB.From;
            if (Parametry.OkresB.To >= Parametry.OkresA.To)
                dto = Parametry.OkresB.To;
            else
                dto = Parametry.OkresA.To;
            pars.Okres = new FromTo(dfrom, dto);
            ReportHeader.Title += "|OkresA: <strong>" + Parametry.OkresA.ToString() + "</strong>";
            ReportHeader.Title += "|OkresB: <strong>" + Parametry.OkresB.ToString() + "</strong>";
            if (pars.Kontrahent != null)
                ReportHeader.Title += "|Kontrahent: <strong>" + pars.Kontrahent.ToString() + "</strong>";
            if (pars.Definicja != null)
                ReportHeader.Title += "|Definicja: <strong>" + pars.Definicja.ToString() + "</strong>";
            ReportHeader.Title += "|Cecha towaru: <strong>" + Parametry.CechaTowaru.Name + "</strong>";

            string mar = Parametry.LiczMarze ? "i marża" : "";
            string kat = Parametry.KategoriaRaportu == KategoriaRaportu.Sprzedaż ?
                "Sprzedaż" : Parametry.KategoriaRaportu == KategoriaRaportu.Zakup ?
                "Zakup" : Parametry.KategoriaRaportu == KategoriaRaportu.WydanieMagazynowe ?
                "Wydania magazynowe" : Parametry.KategoriaRaportu == KategoriaRaportu.PrzyjęcieMagazynowe ?
                "Przyjęcia magazynowe" : "";
            ReportHeader.Title += String.Format("|Wynik: <strong>{0} {1}</strong>", kat, mar);

            
            Soneta.Business.View view = PrzygotujView(pars);

            Hashtable result = new Hashtable();
            foreach (DokumentHandlowy dokument in view) {
                if (dokument.Anulowany) continue;
                if (Parametry.IgnorujZaliczkowe && dokument.Definicja.EdycjaWartosci == EdycjaWartosciDokumentu.PozwalajNaMniejsząKwotę) continue;
                if (dokument.Definicja.DuplikatWartosci || dokument.Anulowany) continue;
                if (!Parametry.OkresA.Contains(dokument.Data) && !Parametry.OkresB.Contains(dokument.Data)) continue;

                foreach (PozycjaDokHandlowego pozycja in dokument.Pozycje) {
                    string tCecha = pozycja.Towar.Features[Parametry.CechaTowaru].ToString();
                    Total t = (Total)result[tCecha];
                    if (t == null) {
                        t = new Total(tCecha, Parametry.LiczMarze);
                        result.Add(tCecha, t);
                    }
                    if (dokument.Data >= Parametry.OkresA.From && dokument.Data <= Parametry.OkresA.To)
                        t.AddA(pozycja, tCecha);
                    if (dokument.Data >= Parametry.OkresB.From && dokument.Data <= Parametry.OkresB.To)
                        t.AddB(pozycja, tCecha);
                }
            }

            ArrayList lista = new ArrayList(result.Values);
            lista.Sort();
            Grid.DataSource = lista;
            
            if (!Parametry.LiczMarze)
            {
                MarzaA.Visible = false;
                MarzaB.Visible = false;
                MarzaRW.Visible = false;
                MarzaRP.Visible = false;
            }
        }

    </script>

    <meta content="C#" name="CODE_LANGUAGE" />
    <meta content="JavaScript" name="vs_defaultClientScript" />
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
</head>
<body>
    <form method="post" runat="server" action="#">
    <ea:DataContext ID="dc" runat="server" OnContextLoad="OnContextLoad" Landscape="true">
    </ea:DataContext>
    <eb:ReportHeader ID="ReportHeader" Title="Raport porównawczy wg cech towarów|</STRONG>Magazyn:<STRONG> {0}</STRONG>"
        runat="server" DataMember0="DokHandloweViewInfo+WParams.Magazyn"></eb:ReportHeader>
    <ea:Grid ID="Grid" runat="server" RowTypeName="Soneta.Handel.DokumentHandlowy,Soneta.Handel">
        <Columns>
            <ea:GridColumn Width="4" Align="Right" DataMember="#" Caption="Lp." runat="server" EncodeHTML="True"></ea:GridColumn>
            <ea:GridColumn DataMember="WartośćCechy" Caption="Cecha towaru" NoWrap="True" runat="server" EncodeHTML="True"></ea:GridColumn>
            
            <ea:GridColumn Width="10" Align="Right" DataMember="IlośćA" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Okres A~Ilość"></ea:GridColumn>
            <ea:GridColumn Width="10" Align="Right" DataMember="NettoA" Total="Sum" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Okres A~Netto"></ea:GridColumn>
            <ea:GridColumn ID="MarzaA" Width="10" Align="Right" DataMember="MarzaA" Total="Sum" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Okres A~Marża"></ea:GridColumn>
            
            <ea:GridColumn Width="10" Align="Right" DataMember="IlośćB" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Okres B~Ilość"></ea:GridColumn>
            <ea:GridColumn Width="10" Align="Right" DataMember="NettoB" Total="Sum" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Okres B~Netto"></ea:GridColumn>
            <ea:GridColumn ID="MarzaB" Width="10" Align="Right" DataMember="MarzaB" Total="Sum" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Okres B~Marża"></ea:GridColumn>

            <ea:GridColumn Width="10" Align="Right" DataMember="RóżnicaIlości" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Różnica ilości~wartość"></ea:GridColumn>
            <ea:GridColumn Width="10" Align="Right" DataMember="RóżnicaIlościP" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Różnica ilości~%"></ea:GridColumn>

            <ea:GridColumn Width="10" Align="Right" DataMember="RóżnicaNetto" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Różnica netto~wartość"></ea:GridColumn>
            <ea:GridColumn Width="10" Align="Right" DataMember="RóżnicaNettoP" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Różnica netto~%"></ea:GridColumn>

            <ea:GridColumn ID="MarzaRW" Width="10" Align="Right" DataMember="RoznicaMarza" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Różnica marża~wartość"></ea:GridColumn>
            <ea:GridColumn ID="MarzaRP" Width="10" Align="Right" DataMember="RoznicaMarzaP" Format="{0:n}" runat="server" EncodeHTML="True" Caption="Różnica marża~%"></ea:GridColumn>

        </Columns>
    </ea:Grid>
    <eb:ReportFooter ID="ReportFooter" runat="server" TheEnd="False">
    </eb:ReportFooter>
    </form>
</body>
</html>

